function JContextMenuItem(owner, parent, name, caption)
{
	this.owner    = owner;
	this.parent   = parent;
	this.name     = name;
	this.caption  = caption;
	this.enabled  = true;
	this.menuItems = new Array();

	this.addMenuItem = JContextMenuItem_addMenuItem;
}

function JContextMenuItem_addMenuItem(owner, parent, name, caption)
{
	var obj = new JContextMenuItem(owner, parent, name, caption);
	this.menuItems.push(obj);

	return obj;
}


function JContextMenu(owner, parent, name)
{
	var self = this,
	    _disposed = false;

	this.initialize(owner, parent, name);

	this.menuItems = [];
	this.methods = (cmRender | cmLoad);
	this.showBelow = false;

	this.render        = render;
	this.load          = load;
	this.menuItemClick = null;
	this.addMenuItem   = JBtnMenuItem_addMenuItem;
	this.showMenu      = showMenu;
	this.dispose       = dispose;

	this.onshow        = new JEvent();


	this.owner.addImage("button-arrow", "button-arrow.gif", "controls");
	this.owner.addImage("separator", "separator.gif", "controls");

	function render(fs)
	{
	    renderMenu(fs, self);
	}

	function renderMenu(fs, obj)
	{
		if (obj.menuItems.length > 0)
		{
			var subItems = [];

			fs.append('<div class="btnMenuDiv" id="' + obj.name + '_menu" style="position:absolute;width:auto;top:10;display:none;background-color: white">');
			fs.append('<table class="btnMenu" id="' + obj.name + '_menuTable">');

			obj.menuItems.forEach( function (item, i)
			{
				if (item.caption == '-')
					fs.append('<tr><td><img style="width:100%;height:1" src="'+ self.owner.images["separator"].src + '" /></td></tr>');
				else
				{
					fs.append('<tr><td nowrap="true" style="padding-left: 3; padding-right: 3;"><a class="btnMenuItem" id="' + obj.name + '_item_' + i + '" objName="' + item.name + '" _index="' + i + '" href="javascript:;">' + item.caption + '</a>');
					if (item.menuItems.length > 0)
					{
						fs.append ('<img id="' + item.name + '_img" style="position:relative; top:3; left: -10;" src="' + self.owner.images["button-arrow"].src + '"/>');
						subItems.push(item);
					}
					fs.append('</td></tr>');
				}
			}, self);

			fs.append('</table>');
			fs.append('</div>');

			subItems.forEach( function (itm)
			{
				renderMenu(fs, itm);
			}, self);
		}
	}

	function load()
	{
		if (self.menuItems.length > 0)
		{
			setEvents(self);
		}
	}

	function setEvents(obj)
	{
		obj.menuItems.forEach( function (item, i)
		{
			var ielem = self.$(obj.name + '_item_' + i);
			if (ielem == null)
				return;

			if (item.menuItems.length > 0)
			{
				ielem.onclick = self.click;
				setEvents(item);
			}
			else
				ielem.onclick = getClickFunc (obj, i);
		}, self);
	}

	function getClickFunc(item, idx)
	{
		return function(event) { _menuItemClick.call(self, event, item, idx); };
	}

	function _menuItemClick(event, item, idx)
	{
		utils.cancelEvent(event);
		self.$$('_menu').style.display = 'none';

		if (self.menuItemClick != null)
			self.menuItemClick(item, idx)
	}

	function showMenu(event, elem, posLeft, posTop)
	{
		var menuElem, doc, style, elemTop, height, width, pos, left, top;

		menuElem = self.$$('_menu');
		doc = self.owner.getDocument();
		if (menuElem.parentNode != doc.body)
			doc.body.appendChild(menuElem);

		style = menuElem.style;

		this.onshow.raise(self, style.display == 'none');

		if (style.display != 'none')
		{
			utils.cancelEvent(event);
			style.display = 'none';
			return;
		}

		if ((elem != null) && (elem.getAttribute('objName') != null) && (self.owner.getObject(elem.getAttribute('objName')).constructor == JBtnMenuItem))
			self.owner.registerPopup(menuElem.id, false, event);
		else
			self.owner.registerPopup(menuElem.id, true, event);

		style.zIndex  = utils.getParentZIndex(menuElem) + 1000;
		style.display = 'block';

		if (elem != null)
		{
			elemTop = elem.offsetTop;
			pos = utils.getElementPosition(elem, doc);
		}
		else
		{
			elemTop = posTop;
			pos = { left: posLeft, top: posTop };
		}

		height = menuElem.clientHeight;
		width = menuElem.clientWidth;

/*
		var left = pos.left + elem.offsetWidth + 2;
		if (left + width > doc.body.clientWidth - 15)
		{
			left = doc.body.clientWidth - width - 15;
		}
*/
		left = pos.left + 2;

		top = pos.top - height;
		if (this.showBelow)
		  top = pos.top + ((elem != null) ? elem.offsetHeight : 0) + 2;

		if (pos < 10)
		{
			pos = elemTop;
		}

		style.left = left;
		style.top = top;
	}

	function disposeItems(obj)
	{
		if (obj.menuItems.length > 0)
		{
			obj.menuItems.forEach( function (item, i)
			{
				var elem = self.$(obj.name + '_item_' + i);
				if (elem != null)
					elem.onclick = null;

				disposeItems(item);
			}, self);

			self.$(obj.name + '_menu').parentNode.removeChild(self.$(obj.name + '_menu'));
		}
	}

	function dispose()
	{
		if (_disposed)
			return;

        this.onshow.dispose();
		disposeItems(self);

		self.base.dispose.call(self);
		_disposed = true;
	}

}

JContextMenu.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();